
uniform sampler2D u_texture;
uniform mediump vec4 u_colorTransform;

varying lowp vec4 v_fragmentColor;
varying highp vec2 v_texCoord;

void main()
{
	mediump vec4 color = v_fragmentColor * texture2D(u_texture, v_texCoord);
	mediump vec4 rescaled = vec4((pow((color.xyz - u_colorTransform.x) / (1 - u_colorTransform.x), vec3(u_colorTransform.y)) - u_colorTransform.z) / (1 - u_colorTransform.z), color.w);
	gl_FragColor = mix(color, rescaled, u_colorTransform.w);
}
